/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

/*
 * Transmit packets from every host to every host randomly
 */

#define USE_MPI 1

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <math.h>
#include <assert.h>

#include "mpi.h"

int any(
	caddr_t s,
	int c)
{
	while (*s) if (*s++ == c) return 1;
	return 0;
}

char **line2words(
	char *buf,
	char *seps,
	int  wmax,
	int *wcnt)
{
	char        *wp;
	int          wc;
	char       **words;

	if (wmax < 1 || wmax > BUFSIZ) wmax = BUFSIZ;

	words = (char **) calloc(sizeof(char *), BUFSIZ);
	if (words == NULL) {
		perror("calloc");
		exit(1);
	}

	wc = 0;
	wp = buf;
	while (wc < wmax) {
		while (any(seps, *wp)) ++wp;
		if (*wp == '\0') break;

		words[wc++] = wp;
		while (!any(seps, *wp) && *wp != '\0') ++wp;
		if (wc < wmax && *wp != '\0') *wp++ = '\0';
	}

	if (wcnt) *wcnt = wc;
	return words;
}


main(int argc, char **argv)
{
  int myid;
  int np;
  int a;
  char command[2048];
  FILE *fp;
  int rc;
  char line[2048];

#if USE_MPI
  MPI_Init(&argc,&argv);
  MPI_Comm_size(MPI_COMM_WORLD,&np);
  MPI_Comm_rank(MPI_COMM_WORLD,&myid);
#else
  myid = 0;
#endif

  if (argc < 2) {
    if (myid == 0) {
      fprintf(stderr, "Need a program to execute!\n");
    }
    exit(1);
  }
  strcpy(command, argv[1]);

  /* -N "args_for_N" -a "args for all" */
  a = 2;
  while (a < argc) {
    if (argv[a][0] == '-') {
      if ((isdigit(argv[a][1]) && atoi(argv[a]+1) == myid) ||
          argv[a][1] == 'a') {
	
	if (argc-a < 2) {
	  fprintf(stderr, "[%d] missing arguments!\n", myid);
	  exit(1);
	}
	strcat(command, " ");
	strcat(command, argv[a+1]);
      }
      a+=2;
    } else {
      if (myid == 0) {
	fprintf(stderr, "\"%s\" - confusing argument\n", argv[a]);
      }
      exit(1);
    }
  }

  printf("[%d] %s\n", myid, command);

  if (myid != 0) {
    MPI_Barrier(MPI_COMM_WORLD);
  }

  fp = popen(command, "r");

  if (myid == 0) {
    sleep(1);
    MPI_Barrier(MPI_COMM_WORLD);
  }

  while (fgets(line, sizeof(line), fp) != NULL) {
    printf("[%d] %s", myid, line);
  }

  rc = pclose(fp);
  if (rc != 0) {
    printf("[%d] FAILED return %d\n", myid, rc);
  }

#if USE_MPI
  MPI_Finalize();
#endif

  return rc;
}
